#ifndef __C_GROUP_H
#define __C_GROUP_H

#include "Interfaces/cObject.h"
#include "Util/cFifo.h"
#include <ostream.h>

class cEndpoint;

/*
 * cGroup.h
 *
 * Interface for an endpoint group.
 */
class cGroup : public cObject
{
  public:
	  cGroup(int size);
	  ~cGroup();
	  bool AddEndpoint(cEndpoint* endpoint);
	  bool RemoveEndpoint(cEndpoint* endpoint);
	  bool IsMember(cEndpoint* endpoint);
	  unsigned int GetNumElements();
	  unsigned int GetSize() { return mTotalSize; }	// Returns the serialization size of all the members.
	  void Print(ostream &errStream);	// Print to the given stream.
	  cIterator*			GetIterator();
	  bool Clear();

	  bool Lock();
	  bool Unlock();

  private:
	unsigned int	mTotalSize;
	cFifo*			mList;
	cFifoIterator	mIterator;
};

#endif